<?php

declare(strict_types=1);

namespace Flasher\Prime\Http;

/**
 * ResponseExtensionInterface - Contract for response modification to include notifications.
 *
 * This interface defines the essential operation for integrating PHPFlasher notifications
 * into HTTP responses. Implementations are responsible for injecting the rendered notification
 * HTML into appropriate locations in the response content.
 *
 * Design pattern: Adapter - Provides a common interface for working with different
 * framework response objects.
 */
interface ResponseExtensionInterface
{
    /**
     * Renders the response by inserting the HTML response generated by the flasher library.
     *
     * This method should analyze the response, determine if and where notifications should
     * be inserted, render them, and modify the response content accordingly.
     *
     * @param RequestInterface  $request  The current request
     * @param ResponseInterface $response The current response
     *
     * @return ResponseInterface The modified response with the HTML response inserted
     */
    public function render(RequestInterface $request, ResponseInterface $response): ResponseInterface;
}
