<?php

declare(strict_types=1);

/*
 * This file is part of the RegexParser package.
 *
 * (c) Younes ENNAJI <younes.ennaji.pro@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace RegexParser\Node;

use RegexParser\NodeVisitor\NodeVisitorInterface;

/**
 * Represents a control character escape sequence (e.g., \cM).
 *
 * This node represents control character escapes in PCRE2,
 * where \c followed by a letter produces the corresponding control character.
 */
final readonly class ControlCharNode extends AbstractNode
{
    public function __construct(
        public string $char,
        public int $codePoint,
        int $startPosition,
        int $endPosition
    ) {
        parent::__construct($startPosition, $endPosition);
    }

    public function accept(NodeVisitorInterface $visitor)
    {
        return $visitor->visitControlChar($this);
    }
}
